function metricForDataDrivenRouting;

% Study the routing metric for data-driven link estimation and routing
%     ETX vs. NT
%
% Author: Hongwei Zhang
% Date: May 10, 2006
%

clear
clc
close all


%%%Theoretical analysis: best \alpha value
%EWMAEstimatorError;
%yun = hongwei

%%%Data-driven analysis
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData\03-12-07a-noMacLatency';
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData\diagonal-12';
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData\LM-xsm-unicast-12-free';
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData\LM-xsm-unicast-12-close';
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData\LM-xsm-unicast-12-middle';
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData\LM-xsm-unicast-12-far';
%srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-1\transformedData\xsm-interferer-free';
srcDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-1\transformedData\xsm-interferer-middle';

%outputFileName = '0xsm-interferer-free.mat';
outputFileName = '0xsm-interferer-middle.mat';


global RELIABILITY_CALC_WINDOW; %for individual broadcast-tx instead of the aggregate unicast
RELIABILITY_CALC_WINDOW = 20;
pastW = 15/16;%7/8;

global RNP_WINDOW_NOT_CONSIDER_ZERO_SUCC_PERIOD;
RNP_WINDOW_NOT_CONSIDER_ZERO_SUCC_PERIOD = 1; %let liveness control of routing to take care of long consecutive failures

global SLIDING_WINDOW_BASED_PDR_CALCULATION;
SLIDING_WINDOW_BASED_PDR_CALCULATION = 0;

TO_PLOT_RAW_TX_COUNT_SERIES_and_HISTOGRAM = 1; %1: yes    0: no

TO_ANALYZE_OPTIMAL_EWMA_ESTIMATOR = 1;
if TO_ANALYZE_OPTIMAL_EWMA_ESTIMATOR == 1 
    RELIABILITY_CALC_WINDOW_OPTS = [20];%[8 16 24 32];
    pastW_OPTS = 15/16;%0.1:0.1:0.9;
    ALPHA = 0.1; %significance level of KS test
end

txStatusFile = 'lm_tx_status.log-0';
rcvFilePrefix = 'lm_rcv.log-'; %followed by node id

FEET_PER_METER = 3.28;

lineSpec{1} = '-+r';
lineSpec{2} = '-ob';
lineSpec{3} = '--vr';
lineSpec{4} = '-.sb';
lineSpec{5} = '-^b';
lineSpec{6} = ':ob';
lineSpec{7} = ':xm';

%%
tp = [];
save(outputFileName, 'tp');

%%get tx status file
data = load('-mat', [srcDir '\' txStatusFile]);
lm_tx_status = data.lm_tx_status; %format: [sender_id  is_broadcast  seqNo  status  num_tx ...
                                  %         mac_latency  powerLevel  pkt_size];
clear data;

receivers = unique(lm_tx_status(:, 2))

%%
trueETX = []; %[receiver-id trueETX]
trueETX_remove_fn = [];
trueBCPDR = []; %[receiver-id trueBCPDR]: for physical-layer BC transission
trueUCPDR = []; %[receiver-id trueUCPDR]: for unicast that may use underlying retransmission
%
ackLossProb = []; %[reciever-id ackLossProb.]
L_NT_via_unicastReliability = []; %[receiver-id L-NT unicastReliability]
L_NT = []; %similar to L_NT_via_unicastReliability, but consider broadcast reliability
%
L_ETX_ewma = []; %[L_ETX_ewma-for-user1 L_ETX_ewma-for-user2 ...]
L_NT_ewma = []; %NT
L_nadv_ewma = []; %NADV
L_RNP_ewma = []; %data-driven RNP
L_RNP_window_ewma = []; %data-driven RNP-window
%
COV_in_ewma = []; % [rcver-id
                  %  mean(NT) std(NT) cov(NT) ...
                  %  mean(PER) std(PER) cov(PER) ...
                  %  mean(PDR) std(PDR) cov(PDR)]
DE_in_ewma = []; %[rcver-id  DE-NT  DE-PER  DE-PDR]
MSE_in_ewma_ETX = []; %[rcver-id  inherent-ETX-variance  ...
                      % mse-for-L_NT-ewma  mse-for-L-nadv-ewma mse-for-L_ETX-ewma  ...
                      % mse-for-L_RNP-ewma  mse-for-L_RNP-window_ewma]
MSE_in_ewma_txCount = []; %[rcver-id  inherent-ETX-variance  
                          % mse-for-L-NT-ewma  mse-for-L-nadv-ewma mse-for-L-ETX-ewma  ...
                          % mse-for-L-RNP-ewma  mse-for-L-RNP-window_ewma]
%
TS_variability = []; %[rcver-id ewma-window-size ...
                     % mean(PDR) std(PDR) cov(PDR) ...
                     % mean(PR_nadv) std(PR_nadv) cov(PR_nadv) ...
                     % mean(RNP) std(RNP) cov(RNP) ...
                     % mean(RNP-window) std(RNP-window) cov(RNP-window)
MSE_optimal_ewma_estimators = [];   %[rcver-id  inherent-ETX-Variance  ewma-window-size ...
                                    % minMSE_L_ETX  minMSE_L_NT  minMSE_L-nadv  minMSE_L_RNP minMSE_L_RNP_window ...
                                    % optimalPastW_L_ETX  optimalPastW_L_NT
                                    % optimalPastW_L-nadv  optimalPastW_L_RNP optimalPastW_L_RNP_window]
KS_TEST_GeoDistribution = []; %[rcver-id H P KSSTAT CV]
minNumRNPRecords_perReciever = 0;

minNumRecords = []; %across all receivers

%Analyze data for each receiver
for indRcver=1:length(receivers)
    disp(['    Is processing receiver: ' num2str(receivers(indRcver)) '   ...']);
    thisRcver = receivers(indRcver);
    %%get the data
    indices = find(lm_tx_status(:, 2) == thisRcver);
    sender_id = lm_tx_status(indices, 1);
    seqNo = lm_tx_status(indices, 3); 
    status = lm_tx_status(indices, 4); %0: failure     1: success
    txCounts = lm_tx_status(indices, 5);
    if isempty(minNumRecords) || minNumRecords > length(txCounts)
        minNumRecords = length(txCounts);
    end
    %%correct txCounts to deal with false negative, using data at the receiver side
    if ~exist([srcDir '\' rcvFilePrefix num2str(thisRcver)], 'file')
        txCounts_remove_fn = txCounts;
        status_remove_fn = status;
    else
        rcvData = load('-mat', [srcDir '\' rcvFilePrefix num2str(thisRcver)]);
        lm_rcv_log = rcvData.lm_rcv_log; %[receiver_id sender_id seqNo is_auto_rate is_broadcast pkt_size reception_time x_loc y_loc link_quality signal_level noise_level powerLevel];
        txCounts_remove_fn = [];
        status_remove_fn = [];
        for ind=1:length(txCounts)
            indices = intersect(find(lm_rcv_log(:, 2) == sender_id(ind)), ... %sender_id
                                find(lm_rcv_log(:, 3) == seqNo(ind)) ... %seqNo
                               );
            if isempty(indices)
                txCounts_remove_fn(ind) = txCounts(ind);
                status_remove_fn(ind) = status(ind);
            elseif length(indices) == 1 %exactly once reception
                txCounts_remove_fn(ind) = txCounts(ind);
                status_remove_fn(ind) = 1;
            else %there is duplicate reception
                txCounts_remove_fn(ind) = txCounts(ind) - length(indices) + 1;
                status_remove_fn(ind) = 1;
            end
        end
    end
    %%plot the time series as need be
    if TO_PLOT_RAW_TX_COUNT_SERIES_and_HISTOGRAM == 1
        txCountsToPresent = [];
        for indStatus=1:length(status)
            if status(indStatus) == 0 %failure
                txCountsToPresent(indStatus) = -1 * txCounts(indStatus);
            else
                txCountsToPresent(indStatus) = txCounts(indStatus);
            end
        end
        %figure('name', ['Node: ' num2str(thisRcver) '    <= time series of txCount']);
        %plot(txCountsToPresent);
        figure('name', ['Node: ' num2str(thisRcver) '    <= histogram of txCount']);
        hist(txCountsToPresent);
    end
    %%analyze the time series
    %trueETX over the time series: expanding each txCount into a sequence of 0, 1
    sumTxes = sum(txCounts);
    sumSuccesses = length(find(status == 1));
    thisTrueETX = sumTxes/sumSuccesses;
    trueETX = [trueETX; ...
               [thisRcver thisTrueETX] ...
              ];
    singleTxReliability = sumSuccesses/sumTxes;
    trueBCPDR = [trueBCPDR; ...
                 [thisRcver singleTxReliability] ...
                ];
    %trueETX_remove_fn (detecting falase negatives, i.e., ack loss)
    sumTxes_remove_fn = sum(txCounts_remove_fn);
    sumSuccesses_remove_fn = length(find(status_remove_fn == 1));
    thisTrueETX_remove_fn = sumTxes_remove_fn/sumSuccesses_remove_fn;
    trueETX_remove_fn = [trueETX_remove_fn; ...
                         [thisRcver thisTrueETX_remove_fn] ...
                        ];
    %ack loss probability
    if exist('lm_rcv_log')
        numPktsRcved = length(find(lm_rcv_log(:, 2) == sender_id(ind)));
        ackLossProb = [ackLossProb; ...
                       [thisRcver (numPktsRcved-sumSuccesses)/numPktsRcved] ...
                      ];
    else 
        ackLossProb = [ackLossProb; ...
                       [thisRcver 0] ...
                      ];
    end
    %estETX over the time series if using NT with 1/q adjustment: q as unicast reliability and broadcast reliability respectively
    indFailures = find(status == 0);
    indSuccesses = find(status == 1);
    unicastReliability = 1 - (length(indFailures) / length(status));    
    modifiedNTs1 = [txCounts(indSuccesses)' (txCounts(indFailures)/unicastReliability)'];
    L_NT_via_unicastReliability = [L_NT_via_unicastReliability; ...
                                     [thisRcver mean(modifiedNTs1) unicastReliability] ...
                                    ];
    modifiedNTs2 = [txCounts(indSuccesses)' (txCounts(indFailures) + (1/singleTxReliability))'];
    L_NT = [L_NT; ...
              [thisRcver mean(modifiedNTs2) singleTxReliability] ...
             ];         
    trueUCPDR = [trueUCPDR; ...
                 [thisRcver unicastReliability] ...
                ];
    %%EWMA-based estimation of trueETX and L_NT
    [PRs_val PRs_nadv_val L_ETX_ewma_serie L_NT_ewma_serie L_nadv_ewma_serie] = ewmaETXEstimators(txCounts, status, RELIABILITY_CALC_WINDOW, pastW);
    for indEwma=1:length(L_ETX_ewma_serie)
        L_ETX_ewma(indEwma, indRcver) = L_ETX_ewma_serie(indEwma);
        L_NT_ewma(indEwma, indRcver) = L_NT_ewma_serie(indEwma);
        L_nadv_ewma(indEwma, indRcver) = L_nadv_ewma_serie(indEwma);
    end
    this_L_ETX_ewma_serie = [repmat(-1, 1, RELIABILITY_CALC_WINDOW) L_ETX_ewma_serie];
    this_L_NT_ewma_serie = [repmat(-1, 1, RELIABILITY_CALC_WINDOW) L_NT_ewma_serie];
    this_L_nadv_ewma_serie = [repmat(-1, 1, RELIABILITY_CALC_WINDOW) L_nadv_ewma_serie];
    %for RNP
    [trueRNPs trueRNPs_window L_RNP_ewma_serie L_RNP_window_ewma_serie len] = ewmaRNPEstimators(txCounts, status, pastW);
    for indEwma=1:length(L_RNP_ewma_serie)
        L_RNP_ewma(indEwma, indRcver) = L_RNP_ewma_serie(indEwma);
        L_RNP_window_ewma(indEwma, indRcver) = L_RNP_window_ewma_serie(indEwma);
    end
    if minNumRNPRecords_perReciever == 0 || minNumRNPRecords_perReciever > len - 1
        minNumRNPRecords_perReciever = len - 1;
    end
    this_L_RNP_ewma_serie = L_RNP_ewma_serie;
    this_L_RNP_window_ewma_serie = L_RNP_window_ewma_serie;
    %%calculate COVs
    %
    meanNT = mean(trueRNPs); 
    stdNT = std(trueRNPs); 
    covNT = stdNT / meanNT;
    %
    meanPER = mean(1 - PRs_nadv_val);
    stdPER = std(1 - PRs_nadv_val);
    covPER = stdPER / meanPER;
    %
    meanPDR = mean(PRs_val);
    stdPDR = std(PRs_val);
    covPDR = stdPDR / meanPDR;
    %
    COV_in_ewma = [COV_in_ewma; ...
                   [thisRcver ...
                    meanNT  stdNT  covNT ...
                    meanPER  stdPER  covPER ...
                    meanPDR  stdPDR  covPDR ...
                   ] ...
                  ];
    %%calculate DEs
    %NT
    thisTrueETX = trueETX(size(trueETX, 1), 2);
    MSE_L_NT_ewma = mean((L_NT_ewma(:, indRcver) - thisTrueETX) .^ 2);
    DE_NT = sqrt(MSE_L_NT_ewma) / thisTrueETX;
    %PER
    thisTruePER = 1- trueBCPDR(size(trueBCPDR, 1), 2);
    MSE_PER_ewma = mean(((1 - PRs_nadv_val) - thisTruePER) .^ 2);
    DE_PER = sqrt(MSE_PER_ewma) / thisTruePER;
    %PDR
    thisTruePDR = trueBCPDR(size(trueBCPDR, 1), 2);
    MSE_PDR_ewma = mean((PRs_val - thisTruePDR) .^ 2);
    DE_PDR = sqrt(MSE_PDR_ewma) / thisTruePER;
    %
    DE_in_ewma = [DE_in_ewma; ...
                  [thisRcver  DE_NT  DE_PER  DE_PDR] ...
                 ];     
    %%calculate MSE of the ewma-based estimation: ETX
    thisTrueETX = trueETX(size(trueETX, 1), 2);
    %
    MSE_L_ETX_ewma = mean((L_ETX_ewma(:, indRcver) - thisTrueETX) .^ 2);
%     if MSE_L_ETX_ewma > 10000 %extremely low reliability or unreachable
%         MSE_L_ETX_ewma = -1;
%     end
    %
    MSE_L_NT_ewma = mean((L_NT_ewma(:, indRcver) - thisTrueETX) .^ 2);
%     if MSE_L_NT_ewma > 10000 
%         MSE_L_NT_ewma = -1;
%     end
    %
    MSE_L_nadv_ewma = mean((L_nadv_ewma(:, indRcver) - thisTrueETX) .^ 2);
%     if MSE_L_nadv_ewma > 10000 
%         MSE_L_nadv_ewma = -1;
%     end
    %
    MSE_L_RNP_ewma = mean((L_RNP_ewma(:, indRcver) - thisTrueETX) .^ 2);
%     if MSE_L_RNP_ewma > 10000 
%         MSE_L_RNP_ewma = -1;
%     end
    %
    MSE_L_RNP_window_ewma = mean((L_RNP_window_ewma(:, indRcver) - thisTrueETX) .^ 2);
%     if MSE_L_RNP_window_ewma > 10000 
%         MSE_L_RNP_window_ewma = -1;
%     end
    %
    inherentETXVariance = mean((trueRNPs - thisTrueETX) .^ 2);
%     if inherentETXVariance > 1000
%         inherentETXVariance = -1;
%     end
    MSE_in_ewma_ETX = [MSE_in_ewma_ETX; ...
                       [thisRcver inherentETXVariance ...
                        MSE_L_NT_ewma  MSE_L_nadv_ewma  MSE_L_ETX_ewma ...
                        MSE_L_RNP_ewma MSE_L_RNP_window_ewma ...
                       ] ...
                      ];
    %%calculate MSE of the ewma-based estimation: txCount
    %
    indices = intersect(find(this_L_ETX_ewma_serie ~= -1), ...
                        find(status ~= 0) ...
                       );
    MSE_L_ETX_ewma = mean((this_L_ETX_ewma_serie(indices) - txCounts(indices)') .^ 2);
%     if MSE_L_ETX_ewma > 10000 %extremely low reliability or unreachable
%         MSE_L_ETX_ewma = -1;
%     end
    %
    indices = intersect(find(this_L_NT_ewma_serie ~= -1), ...
                        find(status ~= 0) ...
                       );
    MSE_L_NT_ewma = mean((this_L_NT_ewma_serie(indices) - txCounts(indices)') .^ 2);
%     if MSE_L_NT_ewma > 10000 %extremely low reliability or unreachable
%         MSE_L_NT_ewma = -1;
%     end
    %
    indices = intersect(find(this_L_nadv_ewma_serie ~= -1), ...
                        find(status ~= 0) ...
                       );
    MSE_L_nadv_ewma = mean((this_L_nadv_ewma_serie(indices) - txCounts(indices)') .^ 2);
%     if MSE_L_nadv_ewma > 10000 %extremely low reliability or unreachable
%         MSE_L_nadv_ewma = -1;
%     end
    %
    indices = intersect(find(this_L_RNP_ewma_serie ~= -1), ...
                        find(status ~= 0) ...
                       );
    MSE_L_RNP_ewma = mean((this_L_RNP_ewma_serie(indices) - txCounts(indices)') .^ 2);
%     if MSE_L_RNP_ewma > 10000 %extremely low reliability or unreachable
%         MSE_L_RNP_ewma = -1;
%     end
    %
    indices = intersect(find(this_L_RNP_window_ewma_serie ~= -1), ...
                        find(status ~= 0) ...
                       );
    MSE_L_RNP_window_ewma = mean((this_L_RNP_window_ewma_serie(indices) - txCounts(indices)') .^ 2);
    %if MSE_L_RNP_window_ewma > 10000 %extremely low reliability or unreachable
    %    MSE_L_RNP_window_ewma = -1;
    %end
    %
    inherentETXVariance = mean((trueRNPs - thisTrueETX) .^ 2);
    if inherentETXVariance > 1000
        inherentETXVariance = -1;
    end
    MSE_in_ewma_txCount = [MSE_in_ewma_txCount; ...
                           [thisRcver  inherentETXVariance  ...
                            MSE_L_NT_ewma  MSE_L_nadv_ewma  MSE_L_ETX_ewma  ...
                            MSE_L_RNP_ewma  MSE_L_RNP_window_ewma ] ...
                          ];    
    %%
    figure('Name', ['Node ' num2str(thisRcver) ' error in estimation ETX (i.e., xxx - actual-ETX)']);
    plot(L_ETX_ewma(:, indRcver) - thisTrueETX, '-b');
    hold on;
    plot(L_NT_ewma(:, indRcver) - thisTrueETX, '-m');
    hold on;
    %plot(L_RNP_ewma(:, indRcver) - thisTrueETX, '--k');
    %hold on;
    %plot(L_RNP_window_ewma(:, indRcver) - thisTrueETX, '--r');
    %hold on;
    plot(L_nadv_ewma(:, indRcver) - thisTrueETX, '-c');
    %legend('L-ETX', 'L-NT', 'L-RNP', 'L-RNP-window', 'L-NADV');
    legend('L-ETX', 'L-NT', 'L-NADV');
    %
    figure('Name', ['Node ' num2str(thisRcver) ' Abs. error in estimation ETX (i.e., xxx - actual-ETX)']);
    plot(abs(L_ETX_ewma(:, indRcver) - thisTrueETX), '-b');
    hold on;
    plot(abs(L_NT_ewma(:, indRcver) - thisTrueETX), '-m');
    hold on;
    %plot(abs(L_RNP_ewma(:, indRcver) - thisTrueETX), '--k');
    %hold on;
    %plot(abs(L_RNP_window_ewma(:, indRcver) - thisTrueETX), '--r');
    %hold on;
    plot(abs(L_nadv_ewma(:, indRcver) - thisTrueETX), '-c');
    %legend('L-ETX', 'L-NT', 'L-RNP', 'L-RNP-window', 'L-NADV');
    legend('L-ETX', 'L-NT', 'L-NADV');

    %%for analyzing optimal EWMA estimator: pastW, pdr calc. window-size
    thisTrueETX = trueETX(size(trueETX, 1), 2);
    if TO_ANALYZE_OPTIMAL_EWMA_ESTIMATOR == 1
        %L_RNP_ewmas
        pastW_vs_MSE_estRNP = []; %[pastW MSE]
        pastW_vs_MSE_L_RNP_window = []; %[pastW MSE]
        for indPastW=1:length(pastW_OPTS)
            [trueRNPs_val  trueRNPs_window_val  L_RNP_ewma_val  L_RNP_window_ewma_val len_val] = ewmaRNPEstimators(txCounts, status, pastW_OPTS(indPastW));
            thisMSE = mean((L_RNP_ewma_val - thisTrueETX) .^ 2);
            thisMSE_window = mean((L_RNP_window_ewma_val - thisTrueETX) .^ 2);
            if thisMSE > 10000
                thisMSE = -1;
            end
            if thisMSE_window > 10000
                thisMSE_window = -1;
            end
            pastW_vs_MSE_estRNP = [pastW_vs_MSE_estRNP; ...
                                   [pastW_OPTS(indPastW) thisMSE] ...
                                  ];
            pastW_vs_MSE_L_RNP_window = [pastW_vs_MSE_L_RNP_window; ...
                                          [pastW_OPTS(indPastW) thisMSE_window] ...
                                         ];
        end
        minMSE_L_RNP = min(pastW_vs_MSE_estRNP(find(pastW_vs_MSE_estRNP(:, 2) >= 0), 2));
        minMSE_L_RNP_window = min(pastW_vs_MSE_L_RNP_window(find(pastW_vs_MSE_L_RNP_window(:, 2) >= 0), 2));
        if isempty(minMSE_L_RNP)
            minMSE_L_RNP = -1;
            optimalPastW_L_RNP = -1;
        else
            optimalPastWInd = find(pastW_vs_MSE_estRNP(:, 2) == minMSE_L_RNP);
            optimalPastW_L_RNP = pastW_vs_MSE_estRNP(optimalPastWInd(1), 1);
        end        
        if isempty(minMSE_L_RNP_window)
            minMSE_L_RNP_window = -1;
            optimalPastW_L_RNP_window = -1;
        else
            optimalPastWInd = find(pastW_vs_MSE_L_RNP_window(:, 2) == minMSE_L_RNP_window);
            optimalPastW_L_RNP_window = pastW_vs_MSE_L_RNP_window(optimalPastWInd(1), 1);
        end
        if mean(trueRNPs_val) > 1000 || std(trueRNPs_val) > 1000
            meanRNP = -1;
            stdRNP = -1;
            covRNP = -1;
        else
            meanRNP = mean(trueRNPs_val);
            stdRNP = std(trueRNPs_val);
            covRNP = stdRNP/meanRNP;
        end
        if mean(trueRNPs_window_val) > 1000 || std(trueRNPs_window_val) > 1000
            meanRNP_window = -1;
            stdRNP_window = -1;
            covRNP_window = -1;
        else
            meanRNP_window = mean(trueRNPs_window_val);
            stdRNP_window = std(trueRNPs_window_val);
            covRNP_window = stdRNP_window/meanRNP_window;
        end
        %analyze the distribution of trueRNPs
        [phat, pci] = mle(trueRNPs_val, 'distribution', 'Geometric');
        %
        figure('Name', ['Q-Q plot for Geometric distribution: receiver = ' num2str(thisRcver)]);
        qqplot(geornd(repmat(phat, 1, length(trueRNPs_val))), trueRNPs_val);
        set(gca, 'FontSize', 16);
        xlabel(['geometric distribution(' num2str(phat) ': CI = (' num2str(pci(1)) ', ' num2str(pci(2)) ')']);
        ylabel('trueRNPs');
        title(['Q-Q plot for Geometric distribution: receiver = ' num2str(thisRcver)]);
        %
        [H, P, KSSTAT, CV] = kstest(trueRNPs_val, [trueRNPs_val; geocdf(trueRNPs_val, phat)]', ALPHA,'unequal');
        KS_TEST_GeoDistribution = [KS_TEST_GeoDistribution; ...
                                   [thisRcver H P KSSTAT CV] ...
                                  ];
        %L_ETX_ewmas, L_NT_ewmas
        for indWin=1:length(RELIABILITY_CALC_WINDOW_OPTS)
            pastW_vs_MSE_trueETX = []; 
            pastW_vs_MSE_estETX = [];
            pastW_vs_MSE_estETX_nadv = [];
            for indPastW=1:length(pastW_OPTS)
                [PRs_val PRs_nadv_val L_ETX_ewma_val L_NT_ewma_val L_nadv_ewma_val] = ewmaETXEstimators(txCounts, status, RELIABILITY_CALC_WINDOW_OPTS(indWin), pastW_OPTS(indPastW));
                thisMSE_trueETX = mean((L_ETX_ewma_val - thisTrueETX) .^ 2);
                if thisMSE_trueETX > 10000
                    thisMSE_trueETX = -1;
                end
                thisMSE_estETX = mean((L_NT_ewma_val - thisTrueETX) .^ 2);
                if thisMSE_estETX > 10000
                    thisMSE_estETX = -1;
                end
                thisMSE_estETX_nadv = mean((L_nadv_ewma_val - thisTrueETX) .^ 2);
                if thisMSE_estETX_nadv > 10000
                    thisMSE_estETX_nadv = -1;
                end
                %
                pastW_vs_MSE_trueETX = [pastW_vs_MSE_trueETX; ...
                                        [pastW_OPTS(indPastW) thisMSE_trueETX] ...
                                       ];
                pastW_vs_MSE_estETX = [pastW_vs_MSE_estETX; ...
                                       [pastW_OPTS(indPastW) thisMSE_estETX] ...
                                      ];
                pastW_vs_MSE_estETX_nadv = [pastW_vs_MSE_estETX_nadv; ...
                                       [pastW_OPTS(indPastW) thisMSE_estETX_nadv] ...
                                      ];
            end %indPastW            
            minMSE_L_ETX = min(pastW_vs_MSE_trueETX(find(pastW_vs_MSE_trueETX(:, 2) >= 0), 2));
            if isempty(minMSE_L_ETX)
                minMSE_L_ETX = -1;
                optimalPastW_L_ETX = -1;
            else
                optimalPastWInd = find(pastW_vs_MSE_trueETX(:, 2) == minMSE_L_ETX);
                optimalPastW_L_ETX = pastW_vs_MSE_trueETX(optimalPastWInd(1), 1);
            end            
            minMSE_L_NT = min(pastW_vs_MSE_estETX(find(pastW_vs_MSE_estETX(:, 2) >= 0), 2));
            if isempty(minMSE_L_NT)
                minMSE_L_NT = -1;
                optimalPastW_L_NT = -1;
            else
                optimalPastWInd = find(pastW_vs_MSE_estETX(:, 2) == minMSE_L_NT);
                optimalPastW_L_NT = pastW_vs_MSE_estETX(optimalPastWInd(1), 1);
            end        
            minMSE_L_nadv = min(pastW_vs_MSE_estETX_nadv(find(pastW_vs_MSE_estETX_nadv(:, 2) >= 0), 2));
            if isempty(minMSE_L_nadv)
                minMSE_L_nadv = -1;
                optimalPastW_L_nadv = -1;
            else
                optimalPastWInd = find(pastW_vs_MSE_estETX_nadv(:, 2) == minMSE_L_nadv);
                optimalPastW_L_nadv = pastW_vs_MSE_estETX_nadv(optimalPastWInd(1), 1);
            end
            meanPR = mean(PRs_val);
            stdPR = std(PRs_val);
            covPR = stdPR / meanPR;
            meanPR_nadv = mean(PRs_nadv_val);
            stdPR_nadv = std(PRs_nadv_val);
            covPR_nadv = stdPR_nadv / meanPR_nadv;
            %plot the data
            figure('name', ['Optimal EWMA: '  'receiver = ' num2str(thisRcver) '     ewma-window = ' num2str(RELIABILITY_CALC_WINDOW_OPTS(indWin))]);
            plot(pastW_vs_MSE_trueETX(:, 1), pastW_vs_MSE_trueETX(:, 2), '-xg');
            hold on;
            plot(pastW_vs_MSE_estETX(:, 1), pastW_vs_MSE_estETX(:, 2), '--+r');
            hold on;
            plot(pastW_vs_MSE_estRNP(:, 1), pastW_vs_MSE_estRNP(:, 2), ':+c');
            hold on;
            plot(pastW_vs_MSE_L_RNP_window(:, 1), pastW_vs_MSE_L_RNP_window(:, 2), ':+k');
            hold on;
            plot(pastW_vs_MSE_estETX_nadv(:, 1), pastW_vs_MSE_estETX_nadv(:, 2), '--+c');
            xlabel('pastW');
            ylabel('MSE');
            legend('L_ETX_ewma', 'L_NT_ewma', 'L_RNP_ewma', 'L_RNP_window_ewma', 'L_nadv_ewma');
            %summarize data
            MSE_optimal_ewma_estimators = [MSE_optimal_ewma_estimators; ...
                                           [thisRcver  inherentETXVariance  RELIABILITY_CALC_WINDOW_OPTS(indWin) ...
                                            minMSE_L_ETX  minMSE_L_NT  minMSE_L_nadv  minMSE_L_RNP minMSE_L_RNP_window ...
                                            optimalPastW_L_ETX  optimalPastW_L_NT  optimalPastW_L_RNP optimalPastW_L_RNP_window optimalPastW_L_nadv ...
                                           ] ...
                                          ];
            TS_variability = [TS_variability; ...
                              [thisRcver  RELIABILITY_CALC_WINDOW_OPTS(indWin) ...
                               meanPR  stdPR  covPR ...
                               meanPR_nadv  stdPR_nadv  covPR_nadv ...
                               meanRNP  stdRNP  covRNP ... 
                               meanRNP_window  stdRNP_window  covRNP_window ... 
                              ] ...
                             ];
        end %indWin
    end %TO_ANALYZE_OPTIMAL_EWMA_ESTIMATOR == 1
    
    %%To visualize important parameters etc.
    figure('Name', ['Node ' num2str(thisRcver) ': time series of txCount, L-ETX-ewma, L-NT-ewma, L-RNP-ewma, L-nadv-ewma']);
    plot(txCountsToPresent, '--g');
    hold on;
    plot(this_L_ETX_ewma_serie, '-k');
    hold on;
    plot(this_L_NT_ewma_serie, '--b');
    hold on;
    %plot(this_L_RNP_ewma_serie, '--.k');
    %hold on;
    %plot(this_L_RNP_window_ewma_serie, '--c');
    %hold on;
    plot(this_L_nadv_ewma_serie, '--r');
    hold on;
    plot([0 length(txCountsToPresent)-1], [thisTrueETX thisTrueETX], '--m');
    %hold on;
    %plot([0 length(txCountsToPresent)-1], [thisTrueETX_remove_fn thisTrueETX_remove_fn], '--y');
    set(gca, 'FontSize', 30);
    legend('txCount', 'L-ETX', 'L-NT', ... %'RNP', 'L-RNP-window', 
           'L-NADV', 'trueETX');%, 'trueETX-remove-fn');
    
    %hongwei = yun
    clear indices data txCounts status txCountsToPresent indFailures modifiedNTs1 modifiedNTs2 sender_id seqNo rcvData lm_rcv_log txCounts_remove_fn status_remove_fn;
end  %for each receiver

trueETX
trueETX_remove_fn
ackLossProb
L_NT_via_unicastReliability
L_NT

COV_in_ewma = sortrows(COV_in_ewma, 1)
DE_in_ewma = sortrows(DE_in_ewma, 1)
MSE_in_ewma_ETX 
MSE_in_ewma_txCount
save(outputFileName, 'COV_in_ewma', 'DE_in_ewma', 'MSE_in_ewma_ETX', 'MSE_in_ewma_txCount', '-append');
%
figure('Name', 'COV-in-ewma')
plot(COV_in_ewma(:, 1) * (3/FEET_PER_METER), COV_in_ewma(:, 4), lineSpec{1}); %L-NT
hold on;
plot(COV_in_ewma(:, 1) * (3/FEET_PER_METER), COV_in_ewma(:, 7), lineSpec{2}); %L-NADV
hold on;
plot(COV_in_ewma(:, 1) * (3/FEET_PER_METER), COV_in_ewma(:, 10), lineSpec{3}); %L-ETX
set(gca, 'FontSize', 30);%, 'YScale', 'log');
xlabel('distance (meter)');
ylabel('COV');
legend('L-NT', 'L-NADV', 'L-ETX');
%
figure('Name', 'DE-in-ewma')
plot(DE_in_ewma(:, 1) * (3/FEET_PER_METER), DE_in_ewma(:, 2), lineSpec{1}); %L-NT
hold on;
plot(DE_in_ewma(:, 1) * (3/FEET_PER_METER), DE_in_ewma(:, 3), lineSpec{2}); %L-NADV
hold on;
plot(DE_in_ewma(:, 1) * (3/FEET_PER_METER), DE_in_ewma(:, 4), lineSpec{3}); %L-ETX
set(gca, 'FontSize', 30);%, 'YScale', 'log');
xlabel('distance (meter)');
ylabel('DE');
legend('L-NT', 'L-NADV', 'L-ETX');
%
figure('Name', 'MSE-in-ewma-etx')
plot(MSE_in_ewma_ETX(:, 1) * (3/FEET_PER_METER), MSE_in_ewma_ETX(:, 3), lineSpec{1}); %L-NT
hold on;
plot(MSE_in_ewma_ETX(:, 1) * (3/FEET_PER_METER), MSE_in_ewma_ETX(:, 4), lineSpec{2}); %L-NADV
hold on;
plot(MSE_in_ewma_ETX(:, 1) * (3/FEET_PER_METER), MSE_in_ewma_ETX(:, 5), lineSpec{3}); %L-ETX
set(gca, 'FontSize', 30, 'YScale', 'log');
xlabel('distance (meter)');
ylabel('MSE');
legend('L-NT', 'L-NADV', 'L-ETX');
%
figure('Name', 'MSE-in-ewma-txCount')
plot(MSE_in_ewma_txCount(:, 1) * (3/FEET_PER_METER), MSE_in_ewma_txCount(:, 3), lineSpec{1}); %L-NT
hold on;
plot(MSE_in_ewma_txCount(:, 1) * (3/FEET_PER_METER), MSE_in_ewma_txCount(:, 4), lineSpec{2}); %L-NADV
hold on;
plot(MSE_in_ewma_txCount(:, 1) * (3/FEET_PER_METER), MSE_in_ewma_txCount(:, 5), lineSpec{3}); %L-ETX
set(gca, 'FontSize', 30, 'YScale', 'log');
xlabel('distance (meter)');
ylabel('MSE');
legend('L-NT', 'L-NADV', 'L-ETX');



MSE_optimal_ewma_estimators
TS_variability
KS_TEST_GeoDistribution


%estimation error via NT
%format: [receiver-id  trueETX  estErr  coeffient-of-error]
NTbasedEstError_via_unicastReliability = [trueETX(:, 1) trueETX(:, 2) (L_NT_via_unicastReliability(:, 2)-trueETX(:, 2)) abs(L_NT_via_unicastReliability(:, 2)-trueETX(:, 2))./trueETX(:, 2)]
NTbasedEstError_via_singleTxReliability = [trueETX(:, 1) trueETX(:, 2) (L_NT(:, 2)-trueETX(:, 2)) abs(L_NT(:, 2)-trueETX(:, 2))./trueETX(:, 2)]

%impact on routing
save(outputFileName, 'trueBCPDR', 'trueUCPDR', '-append');
%L-*
trueMetric = trueETX(:, 2) ./ trueETX(:, 1);
trueMetric = [trueETX(:, 1) trueMetric]; %[receiver-id  metric]
trueMetric = sortrows(trueMetric, 2)  
TRUE_BEST_FORWARDER = trueMetric(1, 1)
save(outputFileName, 'trueMetric', '-append');

trueMetric_remove_fn = trueETX_remove_fn(:, 2) ./ trueETX_remove_fn(:, 1);
trueMetric_remove_fn = [trueETX_remove_fn(:, 1) trueMetric_remove_fn]; %[receiver-id  metric]
trueMetric_remove_fn = sortrows(trueMetric_remove_fn, 2)  
TRUE_BEST_FORWARDER_remove_fn = trueMetric_remove_fn(1, 1)
save(outputFileName, 'trueMetric_remove_fn', '-append');

estMetric_via_unicastReliability = L_NT_via_unicastReliability(:, 2) ./ L_NT_via_unicastReliability(:, 1);
estMetric_via_unicastReliability = [L_NT_via_unicastReliability(:, 1) estMetric_via_unicastReliability]; %[receiver-id  metric]
estMetric_via_unicastReliability = sortrows(estMetric_via_unicastReliability, 2)

estMetric_via_singleTxReliability = L_NT(:, 2) ./ L_NT(:, 1);
estMetric_via_singleTxReliability = [L_NT(:, 1) estMetric_via_singleTxReliability]; %[receiver-id  metric]
estMetric_via_singleTxReliability = sortrows(estMetric_via_singleTxReliability, 2)
EST_BEST_FORWARDER = estMetric_via_singleTxReliability(1, 1)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%EWMA-ETX 
NTbasedEstError_ewma = []; %[receiver-id mean-abs-est-error  min-abs-est-error  max-abs-est-error]
for indRcver=1:length(receivers)
    thisRcver = receivers(indRcver);
    absErrors = abs(L_NT_ewma(1:(minNumRecords-RELIABILITY_CALC_WINDOW), indRcver) - ...
                    L_ETX_ewma(1:(minNumRecords-RELIABILITY_CALC_WINDOW), indRcver) ...
                   );
    NTbasedEstError_ewma = [NTbasedEstError_ewma; ...
                            [thisRcver mean(absErrors) min(absErrors) max(absErrors)] ...
                           ];
    figure('name', ['Node: ' num2str(thisRcver) '    <= L_NT_ewma - L_ETX_ewma']);
    %plot(L_ETX_ewma(1:(minNumRecords-RELIABILITY_CALC_WINDOW), indRcver), '-+g');
    %hold on;
    plot(L_NT_ewma(1:(minNumRecords-RELIABILITY_CALC_WINDOW), indRcver), '--xr');
    hold on;
    plot(L_NT_ewma(1:(minNumRecords-RELIABILITY_CALC_WINDOW), indRcver) - L_ETX_ewma(1:(minNumRecords-RELIABILITY_CALC_WINDOW), indRcver), '-+g');
    legend('estETX\_ewma', 'estETX\_ewma - trueETX\_ewma');
    
    clear absErrors;
end
NTbasedEstError_ewma
%Impact of EWMA-ETX on routing 
forwarder_L_ETX = [];
forwarder_L_NT = [];
forwarder_estMetricRNP = [];
L_ETX_Metric_ewma = [];
L_NT_Metric_ewma = [];
L_RNP_Metric_ewma = [];
L_RNP_window_Metric_ewma = [];
for indRcver=1:length(receivers)
    thisRcver = receivers(indRcver);
    L_ETX_Metric_ewma(:, indRcver) = L_ETX_ewma(:, indRcver)/ thisRcver;
    L_NT_Metric_ewma(:, indRcver) = L_NT_ewma(:, indRcver)/ thisRcver;
    L_RNP_Metric_ewma(:, indRcver) = L_RNP_ewma(:, indRcver)/ thisRcver;
    L_RNP_window_Metric_ewma(:, indRcver) = L_RNP_window_ewma(:, indRcver)/ thisRcver;
end
for indRec=1:(minNumRecords-RELIABILITY_CALC_WINDOW)
    %L_ETX
    thisMetric = L_ETX_Metric_ewma(indRec, :);
    indRcver = find(thisMetric == min(thisMetric));
    if length(indRcver) > 1
        indRcver = max(indRcver);
    end
    forwarder_L_ETX(indRec) = receivers(indRcver);
    %L_NT
    thisMetric = L_NT_Metric_ewma(indRec, :);
    indRcver = find(thisMetric == min(thisMetric));
    if length(indRcver) > 1
        indRcver = max(indRcver);
    end
    forwarder_L_NT(indRec) = receivers(indRcver);
end
for indRec=1:minNumRNPRecords_perReciever
    thisMetric = L_RNP_Metric_ewma(indRec, :);
    indRcver = find(thisMetric == min(thisMetric));
    if length(indRcver) > 1
        indRcver = max(indRcver);
    end
    forwarder_estMetricRNP(indRec) = receivers(indRcver);    
end
for indRec=1:minNumRNPRecords_perReciever
    thisMetric = L_RNP_window_Metric_ewma(indRec, :);
    indRcver = find(thisMetric == min(thisMetric));
    if length(indRcver) > 1
        indRcver = max(indRcver);
    end
    forwarder_estMetricRNP_window(indRec) = receivers(indRcver);    
end
figure('name', ['Routing forwarder L_NT_Metric_ewma vs. L_ETX_Metric_ewma']);
% plot(forwarder_L_ETX, '-+g');
% hold on;
plot(forwarder_L_NT, '--xr');
hold on;
plot(forwarder_L_NT - forwarder_L_ETX, '-+g');
legend('forwarder\_L-NT', 'forwarder\_L-NT - forwarder\_L-ETX');

%%Check correctness in choosing the best forwarder
%L_ETX
forwarders = unique(forwarder_L_ETX);
forwarderHist_L_ETX = []; %[forwarder-id   #-of-times-used  TRUE-best-forwarder]
for ind=1:length(forwarders)
    forwarderHist_L_ETX = [forwarderHist_L_ETX; ...
                             [forwarders(ind) length(find(forwarder_L_ETX == forwarders(ind))) TRUE_BEST_FORWARDER]...
                            ];
end
forwarderHist_L_ETX
%L_NT
forwarders = unique(forwarder_L_NT);
forwarderHist_L_NT = []; %[forwarder-id   #-of-times-used  TRUE-best-forwarder]
for ind=1:length(forwarders)
    forwarderHist_L_NT = [forwarderHist_L_NT; ...
                            [forwarders(ind) length(find(forwarder_L_NT == forwarders(ind))) TRUE_BEST_FORWARDER]...
                           ];
end
forwarderHist_L_NT
%estRNP
forwarders = unique(forwarder_estMetricRNP);
forwarderHist_estMetricRNP = []; %[forwarder-id   #-of-times-used  TRUE-best-forwarder]
for ind=1:length(forwarders)
    forwarderHist_estMetricRNP = [forwarderHist_estMetricRNP; ...
                               [forwarders(ind) length(find(forwarder_estMetricRNP == forwarders(ind))) TRUE_BEST_FORWARDER]...
                              ];
end
forwarderHist_estMetricRNP
%L-RNP-window
forwarders = unique(forwarder_estMetricRNP_window);
forwarderHist_estMetricRNP_window = []; %[forwarder-id   #-of-times-used  TRUE-best-forwarder]
for ind=1:length(forwarders)
    forwarderHist_estMetricRNP_window = [forwarderHist_estMetricRNP_window; ...
                               [forwarders(ind) length(find(forwarder_estMetricRNP_window == forwarders(ind))) TRUE_BEST_FORWARDER]...
                              ];
end
forwarderHist_estMetricRNP_window

%stability of routing: # of parent changes
numOfParentChanges_L_ETX = 0;
for ind=2:length(forwarder_L_ETX)
    if forwarder_L_ETX(ind) ~= forwarder_L_ETX(ind-1)
        numOfParentChanges_L_ETX = numOfParentChanges_L_ETX + 1;
    end
end
numOfParentChanges_L_ETX

numOfParentChanges_L_NT = 0;
for ind=2:length(forwarder_L_NT)
    if forwarder_L_NT(ind) ~= forwarder_L_NT(ind-1)
        numOfParentChanges_L_NT = numOfParentChanges_L_NT + 1;
    end
end
numOfParentChanges_L_NT

numOfParentChanges_estMetricRNP = 0;
for ind=2:length(forwarder_estMetricRNP)
    if forwarder_estMetricRNP(ind) ~= forwarder_estMetricRNP(ind-1)
        numOfParentChanges_estMetricRNP = numOfParentChanges_estMetricRNP + 1;
    end
end
numOfParentChanges_estMetricRNP

numOfParentChanges_estMetricRNP_window = 0;
for ind=2:length(forwarder_estMetricRNP_window)
    if forwarder_estMetricRNP_window(ind) ~= forwarder_estMetricRNP_window(ind-1)
        numOfParentChanges_estMetricRNP_window = numOfParentChanges_estMetricRNP_window + 1;
    end
end
numOfParentChanges_estMetricRNP_window




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ret_val] = leftShift(array_arg, numOfBits)
count = 1;
for ind=1+numOfBits:length(array_arg)
    ret_val(count) = array_arg(ind);
    count = count + 1;
end
if count <= length(array_arg)
    for ind=count:length(array_arg)
        ret_val(ind) = 0;
    end
end


% =================================== %
function [PRs_ret PRs_nadv_ret L_ETX_ewma_ret L_NT_ewma_ret L_nadv_ewma_ret] = ewmaETXEstimators(txCounts_arg, status_arg, RELIABILITY_CALC_WINDOW_arg, pastW_arg)

global SLIDING_WINDOW_BASED_PDR_CALCULATION;

perTxSeries = repmat(0, 1, RELIABILITY_CALC_WINDOW_arg); %used for sliding-window based estimation only
for ind=1:RELIABILITY_CALC_WINDOW_arg
    perTxSeries = leftShift(perTxSeries, txCounts_arg(ind));
    if status_arg(ind) == 1
        perTxSeries(RELIABILITY_CALC_WINDOW_arg) = 1;
    end
end
%
singleTxReliability_fn = length(find(status_arg(1:RELIABILITY_CALC_WINDOW_arg) == 1)) / sum(txCounts_arg(1:RELIABILITY_CALC_WINDOW_arg));
if singleTxReliability_fn <= 0
    singleTxReliability_fn = 0.000000001
end
%
PRs_ret = [];
PRs_ret = [PRs_ret singleTxReliability_fn];
PRs_nadv_ret = [];
PRs_nadv_ret = [PRs_ret singleTxReliability_fn];
PER = 0;
numSend = 0; numSucc = 0;
len = 1;
for indTxCount=(RELIABILITY_CALC_WINDOW_arg+1):length(txCounts_arg)
    %reliability
    if SLIDING_WINDOW_BASED_PDR_CALCULATION == 0 %stable estimator
        numSend = numSend + txCounts_arg(indTxCount);
        if status_arg(indTxCount) == 1
            numSucc = numSucc + 1;
        end
        if numSend >= RELIABILITY_CALC_WINDOW_arg
            thisReliability = numSucc / numSend;
            singleTxReliability_fn = singleTxReliability_fn * pastW_arg + thisReliability * (1 - pastW_arg);
            if singleTxReliability_fn <= 0
                singleTxReliability_fn = 0.000000001
            end
            PRs_ret = [PRs_ret singleTxReliability_fn];
            numSend = 0; numSucc = 0;
        end
    else %sliding window calc
        perTxSeries = leftShift(perTxSeries, txCounts_arg(indTxCount));
        if status_arg(indTxCount) == 1
            perTxSeries(RELIABILITY_CALC_WINDOW_arg) = 1;
        end
        thisReliability = length(find(perTxSeries == 1)) / RELIABILITY_CALC_WINDOW_arg;
        singleTxReliability_fn = singleTxReliability_fn * pastW_arg + thisReliability * (1 - pastW_arg);
        if singleTxReliability_fn <= 0
            singleTxReliability_fn = 0.000000001
        end
        PRs_ret = [PRs_ret singleTxReliability_fn];
    end

    %%ETX_ewmaS
    L_ETX_ewma_ret(len) = 1 / singleTxReliability_fn;
    %
    if len == 1
        L_NT_ewma_ret(len) = txCounts_arg(indTxCount);
    elseif status_arg(indTxCount) == 1
        L_NT_ewma_ret(len) = L_NT_ewma_ret(len-1) * pastW_arg + txCounts_arg(indTxCount) * (1 - pastW_arg);
    else
        L_NT_ewma_ret(len) = L_NT_ewma_ret(len-1) * pastW_arg + (txCounts_arg(indTxCount) + 1/singleTxReliability_fn)...
                                                                                                * (1 - pastW_arg);
    end
    %%L_nadv_ewmaS
    for ind=1:txCounts_arg(indTxCount)-1
        PER = PER * pastW_arg + 1 * (1 - pastW_arg);
    end
    if status_arg(indTxCount) == 1
        PER = PER * pastW_arg;
    else
        PER = PER * pastW_arg + 1 * (1 - pastW_arg);
    end
    %if PER ~= 1
        PRs_nadv_ret = [PRs_nadv_ret (1 - PER)];
    %end
    if len == 1
        L_nadv_ewma_ret(len) = txCounts_arg(indTxCount);
    elseif PER ~= 1
        L_nadv_ewma_ret(len) = 1 / (1 - PER);
    else
        L_nadv_ewma_ret(len) = L_nadv_ewma_ret(len - 1);
    end
    
    %
    len = len + 1;
end


%%
function [trueRNPs_ret trueRNPs_window_ret L_RNP_ewma_ret L_RNP_window_ewma_ret len_ret] = ewmaRNPEstimators(txCounts_arg, status_arg, pastW_arg)

global RELIABILITY_CALC_WINDOW;
global RNP_WINDOW_NOT_CONSIDER_ZERO_SUCC_PERIOD;

trueRNPs_ret = [];
trueRNPs_window_ret = [];
thisRNP = 0;
len_ret = 1;
init_val = -1;
L_RNP_ewma_ret(len_ret) = init_val; %initialized to a very large number
L_RNP_window_ewma_ret(len_ret) = init_val;
thisSend = 0; 
thisSucc = 0;
for indTxCount = 1:length(txCounts_arg)
    thisRNP = thisRNP + txCounts_arg(indTxCount);
    if status_arg(indTxCount) == 1
        trueRNPs_ret = [trueRNPs_ret thisRNP];
        if len_ret <= 1 || L_RNP_ewma_ret(len_ret-1) == init_val
            L_RNP_ewma_ret(len_ret) = thisRNP;
            for indTp=len_ret-1:-1:1
                L_RNP_ewma_ret(indTp) = thisRNP;
            end
        else
            L_RNP_ewma_ret(len_ret) = L_RNP_ewma_ret(len_ret-1) * pastW_arg + thisRNP * (1 - pastW_arg);
        end
        thisRNP = 0;
        %
        thisSend = thisSend + txCounts_arg(indTxCount);
        thisSucc = thisSucc + 1;
        if thisSend > RELIABILITY_CALC_WINDOW && (RNP_WINDOW_NOT_CONSIDER_ZERO_SUCC_PERIOD == 1 || thisSucc > 0)
            if thisSucc > 0
                trueRNPs_window_ret = [trueRNPs_window_ret thisSend/thisSucc];
            end
            if thisSucc > 0 && (len_ret <= 1 || L_RNP_window_ewma_ret(len_ret-1) == init_val)
                L_RNP_window_ewma_ret(len_ret) = thisSend/thisSucc;
                for indTp=len_ret-1:-1:1
                    L_RNP_window_ewma_ret(indTp) = thisSend/thisSucc;
                end
            elseif thisSucc > 0
                L_RNP_window_ewma_ret(len_ret) = L_RNP_window_ewma_ret(len_ret-1) * pastW_arg + (thisSend/thisSucc) * (1 - pastW_arg);
            elseif len_ret > 1
                L_RNP_window_ewma_ret(len_ret) = L_RNP_window_ewma_ret(len_ret-1);
            end
            thisSend = 0; 
            thisSucc = 0;
        elseif len_ret > 1
            L_RNP_window_ewma_ret(len_ret) = L_RNP_window_ewma_ret(len_ret-1);
        end
    else %0
        if len_ret > 1
            L_RNP_ewma_ret(len_ret) = L_RNP_ewma_ret(len_ret-1);
            L_RNP_window_ewma_ret(len_ret) = L_RNP_window_ewma_ret(len_ret-1);
        end
        %
        thisSend = thisSend + txCounts_arg(indTxCount);
    end

    len_ret = len_ret + 1;
end


%%
function EWMAEstimatorError

plotDetailedFigure = 1; %0: no   1: yes

ALPHAs = 0.01:0.01:0.99;
Ks = 2:1:100;%5:10:55;

kVSalpha = []; %[k optimal-alpha]
for ind=1:length(Ks)
    ERRs = (2 * realpow(ALPHAs, repmat(2*Ks(ind)+1, 1, length(ALPHAs))) ...
            + realpow(ALPHAs, repmat(2*Ks(ind), 1, length(ALPHAs))) ...
            - 2*ALPHAs + 1 ...
           ) ./ (1 + ALPHAs);
    optimalAlphaInd = find(ERRs == min(ERRs));
    for ind2=1:length(optimalAlphaInd)
        kVSalpha = [kVSalpha; [Ks(ind) ALPHAs(optimalAlphaInd(ind2))]];
    end
    if plotDetailedFigure == 1
        figure('Name', ['EWMA estimation error coeefficient: K = ' num2str(Ks(ind))]);
        plot(ALPHAs, ERRs);
        xlabel('\alpha');
        ylabel('EWMA est. error coeff.');
        title(['K = ' num2str(Ks(ind))]);
    end
end
kVSalpha

figure('Name', 'K vs. optimal alpha (theoretical analysis)');
plot(kVSalpha(:, 1), kVSalpha(:, 2));
grid on;
xlabel('k (time series index)');
ylabel('\alpha with minimum est. error coefficient');
